/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.config.gun;

import dev.toma.configuration.config.Configurable;
import dev.toma.gunsrpg.api.common.IJamConfig;
import dev.toma.gunsrpg.api.common.IWeaponConfig;
import dev.toma.gunsrpg.config.gun.JamConfig;
import lib.toma.animations.Easings;

public class WeaponConfiguration
implements IWeaponConfig {
    @Configurable
    @Configurable.Range(min=0L, max=32767L)
    @Configurable.Comment(value={"Tick amount for how long projectile is not affected by gravity"})
    public int gravityDelay;
    @Configurable
    @Configurable.Range(min=1L, max=10000L)
    @Configurable.Comment(value={"Projectile velocity in m/s"})
    public int velocity;
    @Configurable
    @Configurable.DecimalRange(min=1.0)
    @Configurable.Comment(value={"Projectile damage"})
    public float damage;
    @Configurable
    @Configurable.DecimalRange(min=0.0, max=1.0)
    @Configurable.Comment(value={"Visual recoil multiplier"})
    public float recoilAnimationScale = 1.0f;
    @Configurable
    @Configurable.Comment(value={"Weapon jamming settings"})
    public IJamConfig jamConfig;

    public WeaponConfiguration(float damage, int velocity, int delay, float jamMin, float jamMax) {
        this(damage, velocity, delay, jamMin, jamMax, IJamConfig.DEFAULT_EASING);
    }

    public WeaponConfiguration(float damage, int velocity, int delay, float jamMin, float jamMax, Easings easing) {
        this.gravityDelay = delay;
        this.damage = damage;
        this.velocity = velocity;
        this.jamConfig = new JamConfig(jamMin, jamMax, easing);
    }

    @Override
    public float getDamage() {
        return this.damage;
    }

    @Override
    public float getVelocity() {
        return (float)this.velocity / 20.0f;
    }

    @Override
    public int getGravityDelay() {
        return this.gravityDelay;
    }

    @Override
    public IJamConfig getJamConfig() {
        return this.jamConfig;
    }

    @Override
    public float getRecoilAnimationScale() {
        return this.recoilAnimationScale;
    }
}

